#Libraries

if(!require(lme4)) install.packages("lme4")       #for GLMMs
if(!require(glmmTMB)) install.packages("glmmTMB")    #for glmmTMB
if(!require(emmeans)) install.packages("emmeans")   #for marginal means etc
if(!require(MuMIn)) install.packages("MuMIn")      #for model comparison
if(!require(broom)) install.packages("broom")     #for tidying outputs
if(!require(DHARMa))  install.packages("DHARMa")   #for residual diagnostics
if(!require(ggeffects)) install.packages("ggeffects") #for partial plots
if(!require(mgcv))  install.packages("mgcv")     #for GAMs
if(!require(performance)) install.packages("performance") #for model diagnostics
if(!require(see)) install.packages("see")       #for model diagnostics
if(!require(GGally))  install.packages("GGally")   #for correlation matrix
if(!require(tidyverse)) install.packages("tidyverse") #for data wrangling etc
if(!require(cowplot)) install.packages("cowplot")   #for adding theme
if(!require(rstanarm))  install.packages("rstanarm") #for fitting models in STAN
if(!require(brms))  install.packages("brms")     #for fitting models in STAN
if(!require(coda))  install.packages("coda")     #for diagnostics
if(!require(bayesplot)) install.packages("bayesplot") #for diagnostics

#Read in data

terrestrial = read_csv('../data/Data_Table_1_Persistence_Data_Terrestrial.csv', trim_ws=TRUE)

#Reformat variables

terrestrial = terrestrial %>% mutate(
  Category=factor(Category),
  Func_Group=factor(Group),
  Threat=factor(Threat),
  Estimate=factor(Estimate),
  Level=factor(Level),
  Pers_fit_trans=sqrt(1-Persistence_fit))

#Subset threats

terrestrial_sub = terrestrial %>% filter(Threat == "Fire" | Threat == "Grazing" | Threat == "Buffalo"| Threat == "Cane toad"| Threat == "Cat"| Threat == "Pig"| Threat == "Perennial grasses") %>% droplevels()
unique(terrestrial_sub$Threat)

#Fit model

zoib_model_terrestrial1 <- bf(
  Persistence ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  phi ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  zoi ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  coi ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  family = zero_one_inflated_beta()
)


fit_terrestrial1 <- brm(
  formula = zoib_model_terrestrial1,
  data = terrestrial_sub,
  iter = 7000,
  chains = 3,
  warmup = 2000,
  thin = 1,
  cores = 8,
  seed = 12345,
  control = list(adapt_delta = 0.99, max_treedepth = 15),
  file = "brm-zoib-terrestrial1"
)

save(fit_terrestrial1,file="../data/ZOIB_aquatic1")
